<?php
/**
 * WooCommerce Page Builder For Elementor Template Hooks
 *
 * Action/filter hooks used for functions/templates
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$theme = wc_get_theme_slug_for_templates();

add_action('dtwcbe_woocommerce_account_view_order_backorder', 'dtwcbe_woocommerce_account_view_order_backorder', 99, 1);

/**
 * Impreza
 */
if( $theme == 'Impreza' && function_exists( 'us_woocommerce_before_main_content' ) ){
	add_action( 'woocommerce_page_builder_before_main_content', 'us_woocommerce_before_main_content', 10 );
	add_action( 'woocommerce_page_builder_after_main_content', 'us_woocommerce_after_main_content', 10 );
}
/**
 * Salient
 */
if( $theme == 'salient'){
add_action('woocommerce_page_builder_before_main_content', 'nectar_shop_wrapper_start', 10 );
add_action('woocommerce_page_builder_after_main_content', 'nectar_shop_wrapper_end', 10 );
}
/**
 * betheme
 */
if( $theme == 'betheme' && function_exists( 'mfn_woocommerce_output_content_wrapper' ) ){
	add_action( 'woocommerce_page_builder_before_main_content', 'mfn_woocommerce_output_content_wrapper', 10 );
	add_action( 'woocommerce_page_builder_after_main_content', 'mfn_woocommerce_output_content_wrapper_end', 10 );
}
/**
 * storefront
 */
if( $theme == 'storefront' ){
	add_action( 'woocommerce_page_builder_before_main_content', 'dtwcbe_storefront_output_content_wrapper', 10 );
	add_action( 'woocommerce_page_builder_after_main_content', 'dtwcbe_storefront_output_content_wrapper_end', 10 );
}
/**
 * The7
 */
if( $theme == 'dt-the7' ){
	add_action( 'woocommerce_page_builder_before_main_content', 'dtwcbe_the7_output_content_wrapper', 10 );
	add_action( 'woocommerce_page_builder_after_main_content', 'dtwcbe_the7_output_content_wrapper_end', 10 );
}
/**
 * kuteshop
 */
if( $theme == 'kuteshop' ){
	add_action( 'woocommerce_page_builder_before_main_content', 'dtwcbe_kuteshop_output_content_wrapper', 10 );
	add_action( 'woocommerce_page_builder_after_main_content', 'dtwcbe_kuteshop_output_content_wrapper_end', 10 );
}

/**
 * u_design
 */
if( $theme == 'u_design' ){
	add_action( 'woocommerce_page_builder_before_main_content', 'dtwcbe_u_design_output_content_wrapper', 10 );
	add_action( 'woocommerce_page_builder_after_main_content', 'dtwcbe_u_design_output_content_wrapper_end', 10 );
}

/**
 * werkstatt
 */
if( $theme == 'werkstatt' ){
	add_action( 'woocommerce_page_builder_before_main_content', 'dtwcbe_werkstatt_output_content_wrapper', 10 );
	add_action( 'woocommerce_page_builder_after_main_content', 'dtwcbe_werkstatt_output_content_wrapper_end', 10 );
}

/**
 * HighendWP
 */
if( $theme == 'HighendWP' ){
	add_action( 'woocommerce_page_builder_before_main_content', 'dtwcbe_HighendWP_output_content_wrapper', 10 );
	add_action( 'woocommerce_page_builder_after_main_content', 'dtwcbe_HighendWP_output_content_wrapper_end', 10 );
}

/**
 * ohio
 */
if( $theme == 'ohio' ){
	add_action( 'woocommerce_page_builder_before_single_product_summary', 'dtwcbe_ohio_output_single_product_wrapper', 10 );
	add_action( 'woocommerce_page_builder_after_single_product_summary', 'dtwcbe_ohio_output_single_product_wrapper_end', 10 );

	add_action( 'woocommerce_page_builder_before_main_content', 'dtwcbe_ohio_output_content_wrapper', 10 );
	add_action( 'woocommerce_page_builder_after_main_content', 'dtwcbe_ohio_output_content_wrapper_end', 10 );
}

/**
 * woodmart
 */
if( $theme == 'woodmart' ){
	add_action( 'woocommerce_page_builder_before_single_product_summary', 'dtwcbe_woodmart_output_single_product_wrapper', 10 );
	add_action( 'woocommerce_page_builder_after_single_product_summary', 'dtwcbe_woodmart_output_single_product_wrapper_end', 10 );
}

/**
 * oceanwp
 */
if( $theme == 'oceanwp' ){
	add_action( 'woocommerce_page_builder_before_main_content', 'dtwcbe_oceanwp_content_wrapper', 10 );
	add_action( 'woocommerce_page_builder_after_main_content', 'dtwcbe_oceanwp_content_wrapper_end', 10 );
}

/**
 * theratio
 */
if( $theme == 'theratio' ){
	add_action( 'woocommerce_page_builder_before_main_content', 'dtwcbe_theratio_content_wrapper', 10 );
	add_action( 'woocommerce_page_builder_after_main_content', 'dtwcbe_theratio_content_wrapper_end', 10 );
}